AOS.init();

window.addEventListener("load", AOS.refresh());
// lenis smooth scroll
const lenis = new Lenis();

lenis.on("scroll", (e) => {
  // console.log(e);
});

function raf(time) {
  lenis.raf(time);
  requestAnimationFrame(raf);
}

requestAnimationFrame(raf);

const images = document.getElementsByClassName("ukiyo");
new Ukiyo(images);

// Select the image element
const image = document.getElementsByClassName("img-zooming");
const controller = new ScrollMagic.Controller();

Array.from(image).forEach((img) => {
  new ScrollMagic.Scene({
    triggerElement: img, // The element that triggers the animation
    triggerHook: "onEnter", // Trigger when the trigger element enters the viewport
  })
    .setTween(img, { scale: 1, duration: 5 }) // GSAP animation
    .addTo(controller);
});

// footer
var footer = document.getElementById("footer");
var scroll = window.scrollY;
var footHeight = footer.offsetHeight;

window.addEventListener("scroll", function () {
  var scrolled = window.scrollY;
  if (scrolled > scroll) {
    footer.classList.add("animate");
    footer.classList.add("sticked");
  } else {
    footer.classList.remove("animate");
    footer.classList.remove("sticked");
  }

  scroll = window.scrollY;
});


function checkForFormParam() {
  const params = new URLSearchParams(window.location.search);
  if (params.get("bookingForm") === "true") {
    formType = "privateMeeting";
    formTitle.innerHTML = `BOOK YOUR PRIVATE MEETING`;
    brochureForm.style.right = "0px";
    backDrop.style.display = "block";
  }
}

// Check on page load
window.addEventListener("DOMContentLoaded", checkForFormParam);

xmark.addEventListener("click", () => {
  brochureForm.style.right = "-100%";
  backDrop.style.display = "none";
});

backDrop.addEventListener("click", () => {
  brochureForm.style.right = "-100%";
  backDrop.style.display = "none";
});

const openForm = (form) => {
  if (form === "brochure") {
    formType = "brochure";
    formTitle.innerHTML = `DOWNLOAD PROJECT BROCHURE`;
  }

  if (form === "privateMeeting") {
    formType = "privateMeeting";
    formTitle.innerHTML = `BOOK YOUR PRIVATE MEETING`;
  }

  brochureForm.style.right = "0px";
  backDrop.style.display = "block";
};

function get_ga_clientid() {
  var cookie = {};
  document.cookie.split(";").forEach(function (el) {
    var splitCookie = el?.split("=");
    var key = splitCookie[0]?.trim();
    var value = splitCookie[1];
    cookie[key] = value;
  });
  return cookie["_ga"]?.substring(6) || "";
}





const phone2 = document.getElementById("phone1");
const bottomFormSection = document.getElementById("bottomFormSection");
const privateBookingFormError = document.getElementById(
  "privateBookingFormError"
);
const bottomFormCta = document.getElementById("bottomFormCta");






const example = [
  {
    title: "WELLNESS SPACES",
    description:
      "Exclusive to residents, Marasi Bay’s wellness spaces offer lush, serene settings for yoga, meditation, and mindful movement, creating daily rituals of renewal by the water’s edge.",

    img: "https://velaviento.omniyat.com/assets/img/slider1/1.webp",
    mobileImg: "https://velaviento.omniyat.com/assets/img/slider1/1.webp",
    position: "object-[left_bottom]",
    mobilePosition: "object-center",
  },
  {
    title: "Urban Beach Club",
    description:
      "A first-of-its-kind floating beach club in the Burj Khalifa District set on Marasi Bay Island, blending sun-soaked leisure with skyline views.",

    img: "/img/slider1/asset12.webp",
    mobileImg: "/img/slider1/asset12-mobile.webp", // Optional: separate mobile image
    position: "object-[left_bottom]", // Desktop position
    mobilePosition: "object-center", // Optional: separate mobile position
  },
  {
    title: "THE SIGNATURE PAVILLION",
    description:
      "Envisioned as an elegant retail destination, the Signature Pavilion will extend gracefully from the promenade into the calm waters of Marasi Bay. Residents and visitors are invited to discover a meticulously curated collection of the world’s most prestigious boutiques and luxury brands, delivering a shopping experience worthy of this extraordinary destination.",

    img: "/img/slider1/asset3.webp",
    mobileImg: "/img/slider1/asset3-mobile.webp",
    position: "object-[left_bottom]",
    mobilePosition: "object-center",
  },
];

const diningSliderData = [
  {
    id: 1,
    title: "Urban Beach Club",
    description:
      "A first-of-its-kind floating beach club in the Burj Khalifa District set on Marasi Bay Island, blending sun-soaked leisure with skyline views.",
    img: "https://velaviento.omniyat.com/assets/img/slider1/1.webp",
    position: "object-[20%_10%] lg:object-[0%_bottom]",
  },
  {
    id: 2,
    title: "Marina Yacht Club",
    description:
      "A refined harbour for arrival and escape, the Marina Yacht Club offers exclusive boating experiences and direct access to the bay. Enhanced promenade upgrades, a pedestrian bridge, and an electric Abra service will improve water connectivity between Marasi Bay Island, The Lana Promenade, and OMNIYAT’s masterpieces.",
    img: "https://velaviento.omniyat.com/assets/img/changes/asset1.webp",
    position: "object-[10%_10%] lg:object-[0%_bottom]",

  },
  
  {
    // title: "Multi-Purpose Signature Pavilion",
    id: 4,
    title: "THE SIGNATURE PAVILLION",
    description:
      "Envisioned as an elegant retail destination, the Signature Pavilion will extend gracefully from the promenade into the calm waters of Marasi Bay. Residents and visitors are invited to discover a meticulously curated collection of the world’s most prestigious boutiques and luxury brands, delivering a shopping experience worthy of this extraordinary destination.",
    img: "https://velaviento.omniyat.com/assets/img/slider1/4.webp",
    position: "object-[86%_10%] lg:object-[0%_bottom] overflow-hidden",
  },
  {
    id: 5,
    title: "Landscaped Waterfront Promenade ",
    description:
      "Shaded walkways and landscaped paths guide movement across Marasi Bay, linking key spaces with ease. Mist-cooling zones and hydration stations offer comfort during outdoor activities, while the area’s prime location between Downtown Dubai and Dubai Design District connects residents to a lifestyle of connectivity and activity.",
    img: "https://velaviento.omniyat.com/assets/img/slider1/5.webp",
  },
  {
    //   title: "Green Spaces and Wellness Sanctuaries",
    id: 6,
    title: "WELLNESS SPACES",
    description:
      "Exclusive to residents, Marasi Bay’s wellness spaces offer lush, serene settings for yoga, meditation, and mindful movement, creating daily rituals of renewal by the water’s edge.",
    img: "https://velaviento.omniyat.com/assets/img/changes/asset8.webp",
  },
  {
    id: 7,
    title: "Michelin-Starred Dining",
    description:
      "A destination for culinary connoisseurs, home to Michelin-starred restaurants overlooking the waters of Marasi Bay.",
    img: "https://velaviento.omniyat.com/assets/img/slider1/7.webp",
    // mobileImg: "/assets/img/slider1/asset2-mobile.jpg",
    // position: "object-[left_bottom]",
    // mobilePosition: "object-center"
  },

  {
    id: 8,
    title: "The Lana Hotel, Dorchester Collection, Dubai",
    img: "https://velaviento.omniyat.com/assets/img/slider1/8.webp",
    description: "Dorchester Collection’s first hotel in the region, a landmark of refined hospitality and contemporary elegance on the waterfront."
  },

  {
    id: 9,
    title: "Dior Spa",
    img: "https://velaviento.omniyat.com/assets/img/slider1/9.webp",
    description: "The region’s first Dior Spa, dedicated to transformative wellbeing in a setting of calm and contemporary beauty."
    // mobileImg: "/assets/img/slider1/asset7-mobile.jpg",
    // position: "object-[left_bottom]",
    // mobilePosition: "object-center"
  },
  {
    id: 10,
    title: "Sunset Park",
    description:
      "A central green space, Sunset Park brings together zones for wellness, leisure, and connection. From a pet-friendly area and picnic lawns to private dining spaces with a chef’s kitchen, every detail supports a vibrant, community-focused lifestyle.",
    img: "https://velaviento.omniyat.com/assets/img/slider/sunset-park.webp",
  },
];

const wrapper = document.querySelector("#diningSlider .swiper-wrapper");
const isMobile = window.innerWidth < 768;

// Helper function to capitalize the first letter of each word and after hyphens
function toTitleCase(str) {
  return str.replace(/\b\w|(?<=-)\w/g, function(txt) {
    return txt.toUpperCase();
  }).replace(/([A-Z])([A-Z]+)/g, (m, p1, p2) => p1 + p2.toLowerCase());
}

diningSliderData.forEach((slide, index) => {
  const slideEl = document.createElement("div");
  slideEl.className = "swiper-slide relative w-full h-full";

  const imageSrc =
    isMobile && slide.id === 6
      ? "https://velaviento.omniyat.com/assets/img/changes/asset8-mobile.webp"
      : isMobile && slide.id === 3
      ? "https://velaviento.omniyat.com/assets/img/slider1/3-mobile.webp"
      : slide.img;

  slideEl.innerHTML = `
      <div class="relative w-full h-full">
        <!-- Background Images -->
        <div class="absolute inset-0">
          <img src="${imageSrc}" alt="${toTitleCase(slide.title) || `Slide ${index + 1}`}" 
            class="object-cover w-full h-full ${slide.position}" />

          <div class="absolute bottom-0 left-0 right-0 lg:h-[15%] ${slide.id === 4 ? "h-[38%]" : "h-[25%]"} slide-overlay"></div>
        </div>

        <!-- Content -->
        <div class="absolute inset-x-0 bottom-10 lg:bottom-4 flex flex-col px-8 lg:px-12">
          <h2 class="text-white mb-0 text-[22px] lg:text-[28px] w-full lg:w-[75%] ">
            ${toTitleCase(slide.title)}
          </h2>
           <p class="text-gray-300 font-normal mb-2 text-[12px] lg:text-[18px] w-full lg:w-[90%] ">
           ${slide.description ? slide.description : ""}
         </p>
        </div>
      </div>
    `;
  wrapper.appendChild(slideEl);
});

// ----------------------
const diningSliderData2 = [
  {
    title: "Architecture by Foster + Partners",
    img: "https://velaviento.omniyat.com/assets/img/one1.jpg",
    copy: "For over 50 years, Foster + Partners, a globally acclaimed architectural name, has been at the forefront of groundbreaking design and sustainable engineering. VELA Viento is a showcase of their exceptional expertise, exemplifying the delights of indoor-outdoor living in lavish proportions that create a sense of vast scale and majesty.",
  },
  {
    title: "Interior design by Gilles & Boissier",
    img: "https://velaviento.omniyat.com/assets/img/two2.jpg",
    copy: "Distilling the essence of elegance and singularity into an art form, Gilles & Boissier seamlessly blend modernity with timeless allure in VELA Viento’s captivating spaces.",
  },
  {
    title: "Designed by BANDA Studio",
    img: "https://velaviento.omniyat.com/assets/img/three3.jpg",
    // copy: "For Horizon Residences, VELA Viento offers a distinctive opportunity to work with BANDA Studio, whose design philosophy merges traditional craftsmanship with modern minimalism to create spaces that are both timeless and innovative.",
    copy:"For Horizon Residences, VELA Viento presents a distinctive capsule collection in collaboration with Banda Studio, whose design philosophy merges traditional craftsmanship with modern minimalism to create spaces that are both timeless and innovative."
  },
];

const wrapper2 = document.querySelector("#diningSlider2 .swiper-wrapper");

diningSliderData2.forEach((slide, index) => {
  const slideEl = document.createElement("div");
  slideEl.className = "swiper-slide relative w-full h-full";

  slideEl.innerHTML = `
     <div class="relative w-full h-full">
       <!-- Background Images -->
       <div class="absolute inset-0">
         <img src="${slide.img}" alt="${toTitleCase(slide.title) || `Slide ${index + 1}`}" 
           class="object-cover w-full h-full ${slide.position}" />

         <div class="absolute bottom-0 left-0 right-0 h-[40%] lg:h-[20%] slide-overlay"></div>
       </div>

       <!-- Content -->
       <div class="absolute inset-x-0 bottom-10 lg:bottom-4 flex flex-col px-8 lg:px-12">
         <h2 class="text-white mb-1 text-[22px] lg:text-[28px] w-full lg:w-[75%] ">
           ${toTitleCase(slide.title)}
         </h2>
          <p class="text-gray-300 font-normal mb-2 text-[12px] lg:text-[18px] w-full lg:w-[90%] ">
           ${slide.copy}
         </p>
       </div>
     </div>
   `;
  wrapper2.appendChild(slideEl);
});

// ----------------------

// Init Swiper
const destinationSwiper = new Swiper(".destinationSwiper", {
  spaceBetween: 0,
  slidesPerView: 1,
  speed: 1000,
  loop: true,
  navigation: {
    nextEl: ".image-swiper-button-next",
    prevEl: ".image-swiper-button-prev",
  },
  // autoplay: {
  //   delay: 5000,
  //   disableOnInteraction: false,
  // },
});
